/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package proc.text;

import java.util.regex.Pattern;
import java.util.regex.Matcher;

// StringUtils.replace() est beaucoup plus rapide que StringStringUtils.replace(,)
import org.apache.commons.lang.StringUtils;

public class Codecs {

    public static String echappeSQL(String s){
        StringBuffer sb = new StringBuffer(s.length());
        int len = s.length();
        char c;
        for (int i = 0; i < len; i++) {
            c = s.charAt(i);
            if (c == '\''){
            
            } else {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    public static String flushNormalText(String s){
        StringBuffer sb = new StringBuffer(s.length());
        for(int i=0; i<s.length(); i++){
            char c = s.charAt(i);
            if(!Character.isLetterOrDigit(c) &&
                    !(c == ' ') &&  // (breaking) spaces
                    !(c == '&') &&  // entities
                    !(c == ';') &&  // entities
                    !(c == '#') &&  // entities
                    !(c == '/')){ // removed, then added in <br/>
                sb.append(c);
            }
        }
        return sb.toString();
    }

    public static String toFileName(String s){
        String x = StringUtils.replace(s,"\"", "");
        x = StringUtils.replace(x,"?", "");
        x = StringUtils.replace(x,"\\", "");
        x = StringUtils.replace(x,"/", "");
        x = StringUtils.replace(x,"<", "");
        x = StringUtils.replace(x,">", "");
        x = StringUtils.replace(x,":", "");
        x = StringUtils.replace(x,"*", "");
        return x.trim();
    }

    private static String desencode(String s){

        // Remplacement des caractères spéciaux (pas seulement Unicode)
        s = StringUtils.replace(s,"Ã?", "É");
        s = StringUtils.replace(s,"â??", "'");
        s = StringUtils.replace(s,"â?¨", " ");
        s = StringUtils.replace(s,"â?¦", "…");
        s = StringUtils.replace(s,"â?¬", "€");
        s = StringUtils.replace(s,"â¬", "€");
        s = StringUtils.replace(s,"â‚¬", "€");
        s = StringUtils.replace(s,"â€Š", " ");
        s = StringUtils.replace(s,"â€¨", " ");
        s = StringUtils.replace(s,"â€¯", " ");
        s = StringUtils.replace(s,"â€“", "-");
        s = StringUtils.replace(s,"â€”", "-");
        s = StringUtils.replace(s,"â€˜", "\"");
        s = StringUtils.replace(s,"â€œ", "\"");
        s = StringUtils.replace(s,"â€Â", "\"");
        s = StringUtils.replace(s,"â€³", "\"");
        s = StringUtils.replace(s,"â€�", "\"");
        s = StringUtils.replace(s,"â€ž", "\"");
        s = StringUtils.replace(s,"â", "\"");
        s = StringUtils.replace(s,"â", "\"");
        s = StringUtils.replace(s,"â€…", "…");
        s = StringUtils.replace(s,"â€Ž", "");
        s = StringUtils.replace(s,"â€˜", "'");
        s = StringUtils.replace(s,"â€™", "'");
        s = StringUtils.replace(s,"â", "'");
        s = StringUtils.replace(s,"â\"™", "'");
        s = StringUtils.replace(s,"â€¦", "…");
        s = StringUtils.replace(s,"â€‰", " ");
        s = StringUtils.replace(s,"Â«", "\"");
        s = StringUtils.replace(s,"Â»", "\"");
        s = StringUtils.replace(s,"<'", "'");
        s = StringUtils.replace(s,"é", "é");
        s = StringUtils.replace(s,"è", "è");
        s = StringUtils.replace(s,"≈†", "\"");
        s = StringUtils.replace(s,"∆¨", "\"");
        s = StringUtils.replace(s,"∆†", "\"");
        s = StringUtils.replace(s,"Ä‚Å¥", "û");
        s = StringUtils.replace(s,"Ä‚Åž", "ê");
        s = StringUtils.replace(s,"Ä‚Å ", "é");
        s = StringUtils.replace(s,"ÃÂ©", "é");
        s = StringUtils.replace(s,"Ä‚Â¨", "è");
        s = StringUtils.replace(s,"Ä‚Â ", "à");
        s = StringUtils.replace(s,"Ä‚Â", "ç");
        s = StringUtils.replace(s,"AÅ¤", "\"");
        s = StringUtils.replace(s,"AÅ¥", "\"");
        s = StringUtils.replace(s,"eÌ�", "é");
        s = StringUtils.replace(s,"oÌ‚", "ô");
        s = StringUtils.replace(s,"eÌ€", "è");
        s = StringUtils.replace(s,"aÌ€", "à");
        s = StringUtils.replace(s,"eÌ", "é");
        s = StringUtils.replace(s,"Ì€", "è");
        s = StringUtils.replace(s,"ç", "ç");
        s = StringUtils.replace(s,"ê", "ê");
        s = StringUtils.replace(s,"è", "è");
        s = StringUtils.replace(s,"ÃÂ©", "é");
        s = StringUtils.replace(s,"ÃÂ´", "ô");
        s = StringUtils.replace(s,"ÃÂ¨", "è");
        s = StringUtils.replace(s,"Ð¥", "X");
        s = StringUtils.replace(s,"Ã—", "*");
        s = StringUtils.replace(s,"Å", "œ");
        s = StringUtils.replace(s,"â", ""); 
        s = StringUtils.replace(s,"â'", "'");
        

        //ISO-8859-1 (latin 1)
        s = StringUtils.replace(s,"Ã", "È");
        s = StringUtils.replace(s,"Ã", "À");
        s = StringUtils.replace(s,"Ã�", "Ï");
        s = StringUtils.replace(s,"Å ", "Š");
        s = StringUtils.replace(s,"Å¡", "š");
        s = StringUtils.replace(s,"Å'", "Œ");
        s = StringUtils.replace(s,"Å\"", "œ");
        s = StringUtils.replace(s,"Å“", "œ");
        s = StringUtils.replace(s,"Å¸", "Ÿ");
        s = StringUtils.replace(s,"Ã¿", "ÿ");
        s = StringUtils.replace(s,"Ã€", "À");
        s = StringUtils.replace(s,"Ã ", "à");
        //s = StringUtils.replace(s,"Ã ", "Á");
        s = StringUtils.replace(s,"Ã¡", "á");
        s = StringUtils.replace(s,"Ã¢", "â");
        s = StringUtils.replace(s,"Ã£", "ã");
        s = StringUtils.replace(s,"Ã„", "Ä");
        s = StringUtils.replace(s,"Ã¤", "ä");
        s = StringUtils.replace(s,"Ã¥", "å");
        s = StringUtils.replace(s,"Ã†", "Æ");
        s = StringUtils.replace(s,"Ã¦", "æ");
        s = StringUtils.replace(s,"Ã‡", "Ç");
        s = StringUtils.replace(s,"Ã§", "ç");
        s = StringUtils.replace(s,"Ãˆ", "È");
        s = StringUtils.replace(s,"Ã¨", "è");
        s = StringUtils.replace(s,"Ã‰", "É");
        s = StringUtils.replace(s,"Ã©", "é");
        s = StringUtils.replace(s,"ÃŠ", "Ê");
        s = StringUtils.replace(s,"Ãª", "ê");
        s = StringUtils.replace(s,"Ã‹", "Ë");
        s = StringUtils.replace(s,"Ã«", "ë");
        s = StringUtils.replace(s,"ÃŒ", "Ì");
        s = StringUtils.replace(s,"Ã¬", "ì");
        //s = StringUtils.replace(s,"Ã ", "Í");
        s = StringUtils.replace(s,"Ã­", "í");
        s = StringUtils.replace(s,"ÃŽ", "Î");
        s = StringUtils.replace(s,"Ã®", "î");
        s = StringUtils.replace(s,"Ã¯", "ï");
        //s = StringUtils.replace(s,"Ã ", "Ð");
        s = StringUtils.replace(s,"Ã°", "ð");
        s = StringUtils.replace(s,"Ã'", "Ñ");
        s = StringUtils.replace(s,"Ã±", "ñ");
        s = StringUtils.replace(s,"Ã'", "Ò");
        s = StringUtils.replace(s,"Ã²", "ò");
        s = StringUtils.replace(s,"Ã\"", "Ó");
        s = StringUtils.replace(s,"Ã³", "ó");
        s = StringUtils.replace(s,"Ã”", "Ô");
        s = StringUtils.replace(s,"Ã´", "ô");
        s = StringUtils.replace(s,"Ã•", "Õ");
        s = StringUtils.replace(s,"Ãµ", "õ");
        s = StringUtils.replace(s,"Ã–", "Ö");
        s = StringUtils.replace(s,"Ã˜", "Ø");
        s = StringUtils.replace(s,"Ã¸", "ø");
        s = StringUtils.replace(s,"Ã™", "Ù");
        s = StringUtils.replace(s,"Ã¹", "ù");
        s = StringUtils.replace(s,"Ãš", "Ú");
        s = StringUtils.replace(s,"Ãº", "ú");
        s = StringUtils.replace(s,"Ã›", "Û");
        s = StringUtils.replace(s,"Ã»", "û");
        s = StringUtils.replace(s,"Ãœ", "Ü");
        s = StringUtils.replace(s,"Ã¼", "ü");
        //s = StringUtils.replace(s,"Ã ", "Ý");
        s = StringUtils.replace(s,"Ã½", "ý");
        s = StringUtils.replace(s,"Ãž", "Þ");
        s = StringUtils.replace(s,"Ã¾", "þ");
        s = StringUtils.replace(s,"ÃŸ", "ß");
        s = StringUtils.replace(s,"Ã¶", "ö");
        s = StringUtils.replace(s,"Ã‚", "Â");
        s = StringUtils.replace(s,"Ã…", "Å");
        s = StringUtils.replace(s,"Ãƒ", "Ã");

        Pattern p = Pattern.compile("[âÃÄÅ]\\W");
        Matcher m = p.matcher(s);
        while(m.find()){
            Out.printErreur("Attention : peut-être un nouveau caractère à échapper (début : "+m.group()+") dans : "+s);
        }

        return s;
    }

    public static String nettoieAvantLemmatisation(String s){
        s = desencode(s);

        StringBuffer sb = new StringBuffer(s.length());
        int len = s.length();
        char c;
        for (int i = 0; i < len; i++) {
            c = s.charAt(i);

            if (c == '"' || c == '«' || c == '»' ||
                    new Integer(c).intValue() == 8220 ||
                    new Integer(c).intValue() == 8221 ||
                    new Integer(c).intValue() == 8222 ||
                    new Integer(c).intValue() == 8243 ||
                    new Integer(c).intValue() == 147 ||
                    new Integer(c).intValue() == 148) { // double quotes : "
                sb.append("\"");
            } else if (c == '-' ||
                    new Integer(c).intValue() == 173 ||
                    new Integer(c).intValue() == 8212 ||
                    new Integer(c).intValue() == 8211) { // -
                sb.append("-");
            } else if (c == '*' ||
                    new Integer(c).intValue() == 8226 ||
                    new Integer(c).intValue() == 183 ||
                    new Integer(c).intValue() == 8211) { // bullets : *
                
            } else if (c == '\'' || c == '’' || c == '`' || c == '´' ||
                    new Integer(c).intValue() == 8216 ||
                    new Integer(c).intValue() == 146 ||
                    new Integer(c).intValue() == 145) { // simple quotes
                sb.append("'");
            } else if (c == ' ' || c == '\t' ||
                    new Integer(c).intValue() == 160 ||
                    new Integer(c).intValue() == 8200 ||
                    new Integer(c).intValue() == 8201) { // spaces
                sb.append(" ");
            } else if (c == ':' ||
                    new Integer(c).intValue() == 150) {
                sb.append(":");
            } else if (new Integer(c).intValue() == 8218) {
                sb.append(",");
            } else if (c == '<') {

            } else if (c == '>') {

            } else if (c == '#') {

            } else if (c == '+') {

            } else if (c == '¡') {

            } else if (c == '¿') {

            } else if (c == '~') {

            } else if (c == '×') {

            } else if (c == 'œ' ||
                    new Integer(c).intValue() == 156) {
                // diphtongues cassées
                sb.append("oe");
            } else if (c == 'æ') {
                sb.append("ae");
            } else if (c == '…') {
                sb.append("...");
            } else if (c == '%') {
                sb.append(" pourcent");
            } else if (c == '½') {
                sb.append(" 1/2");
            } else if (c == '©') {
                sb.append("");
            } else if (c == '®') {
                sb.append("");
            } else if (c == '=') {
                sb.append("");
            } else if (c == '$') {
                sb.append(" dollar ");
            } else if (c == '€') {
                sb.append(" euro ");
            } else if (c == '£') {
                sb.append(" livre ");
            } else if (c == '²') {
                sb.append("");
            } else if (c == '³') {
                sb.append("");
            } else if (c == '\r' ||
                    new Integer(c).intValue() == 65533) {
                sb.append(""); // empty or asian (?) characters
            } else {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    public static String escapeHTML(String s) {
        s = desencode(s);

        StringBuffer sb = new StringBuffer(s.length());
        int len = s.length();
        char c;
        for (int i = 0; i < len; i++) {
            c = s.charAt(i);

            if (c == '"' || c == '«' || c == '»' ||
                    new Integer(c).intValue() == 8220 ||
                    new Integer(c).intValue() == 8221 ||
                    new Integer(c).intValue() == 8222 ||
                    new Integer(c).intValue() == 8243 ||
                    new Integer(c).intValue() == 147 ||
                    new Integer(c).intValue() == 148) { // double quotes : "
                sb.append("&quot;");
            } else if (c == '-' ||
                    new Integer(c).intValue() == 173 ||
                    new Integer(c).intValue() == 8212 ||
                    new Integer(c).intValue() == 8211 ||
                    new Integer(c).intValue() == 8209) { // -
                sb.append("&#45;");
            } else if (c == '*' ||
                    new Integer(c).intValue() == 8226 ||
                    new Integer(c).intValue() == 183) { // bullets : *
                sb.append("&#42;");
            } else if (c == '\'' || c == '’' || c == '`' || c == '´' ||
                    new Integer(c).intValue() == 8216 ||
                    new Integer(c).intValue() == 146 ||
                    new Integer(c).intValue() == 145) { // simple quotes
                sb.append("&#39;");
            } else if (c == ' ' || c == '\t' ||
                    new Integer(c).intValue() == 160 ||
                    new Integer(c).intValue() == 8200 ||
                    new Integer(c).intValue() == 8201 ||
                    new Integer(c).intValue() == 8197 ||
                    new Integer(c).intValue() == 8239) { // spaces
                sb.append(" ");
            } else if (c == ':' ||
                    new Integer(c).intValue() == 150  ||
                    new Integer(c).intValue() == 8594) {
                sb.append("&#58;");
            } else if (new Integer(c).intValue() == 8218) {
                sb.append("&#44;");
            } else if (c == '&') {
                sb.append("&amp;");
            } else if (c == '<') {
                sb.append("&lt;");
            } else if (c == '>') {
                sb.append("&gt;");
            } else if (c == '/') {
                sb.append("&#47;");
            } else if (c == '#') {
                sb.append("&#35;");
            } else if (c == ';') {
                sb.append("&#59;");
            } else if (c == '+') {
                sb.append("&#44;");
            } else if (c == '_') {
                sb.append("&#95;");
            } else if (c == '(') {
                sb.append("&#40;");
            } else if (c == ')') {
                sb.append("&#41;");
            } else if (c == '[') {
                sb.append("&#91;");
            } else if (c == ']') {
                sb.append("&#93;");
            } else if (c == '{') {
                sb.append("&#123;");
            } else if (c == '}') {
                sb.append("&#125;");
            } else if (c == '!') {
                sb.append("&#33;");
            } else if (c == '¡') {
                sb.append("&iexcl;");
            } else if (c == '?') {
                sb.append("&#63;");
            } else if (c == '¿') {
                sb.append("&iquest;");
            } else if (c == 'á') {
                sb.append("&aacute;");
            } else if (c == 'à') {
                sb.append("&agrave;");
            } else if (c == 'â') {
                sb.append("&acirc;");
            } else if (c == 'ä') {
                sb.append("&auml;");
            } else if (c == 'ã') {
                sb.append("&atilde;");
            } else if (c == 'ą') {
                sb.append("&#261;");
            } else if (c == 'ć') {
                sb.append("&#263;");
            } else if (c == 'ć') {
                sb.append("&#263;");
            } else if (c == '¢') {
                sb.append("&#162;");
            } else if (c == 'ç') {
                sb.append("&ccedil;");
            } else if (c == 'é') {
                sb.append("&eacute;");
            } else if (c == 'è') {
                sb.append("&egrave;");
            } else if (c == 'ê') {
                sb.append("&ecirc;");
            } else if (c == 'ë') {
                sb.append("&euml;");
            } else if (c == 'í') {
                sb.append("&iacute;");
            } else if (c == 'î') {
                sb.append("&icirc;");
            } else if (c == 'ï' ||
                    new Integer(c).intValue() == 127) {
                sb.append("&iuml;");
            } else if (c == 'ñ') {
                sb.append("&ntilde;");
            } else if (c == 'ó') {
                sb.append("&oacute;");
            } else if (c == 'ò') {
                sb.append("&oagrave;");
            } else if (c == 'ô') {
                sb.append("&ocirc;");
            } else if (c == 'ö') {
                sb.append("&ouml;");
            } else if (c == 'œ' ||
                    new Integer(c).intValue() == 156) {
                // diphtongues cassées
                sb.append("oe");
            } else if (c == 'Œ' ||
                    new Integer(c).intValue() == 156) {
                // diphtongues cassées
                sb.append("Oe");
            } else if (c == 'æ') {
                sb.append("ae");
            } else if (c == 'ú') {
                sb.append("&uacute;");
            } else if (c == 'ù') {
                sb.append("&ugrave;");
            } else if (c == 'û') {
                sb.append("&ucirc;");
            } else if (c == 'ü') {
                sb.append("&uuml;");
            } else if (c == 'ž') {
                sb.append("&#382;");
            } else if (c == 'Á') {
                sb.append("&Aacute;");
            } else if (c == 'À') {
                sb.append("&Agrave;");
            } else if (c == 'Â') {
                sb.append("&Acirc;");
            } else if (c == 'Å') {
                sb.append("&Aring;");
            } else if (c == 'ß') {
                sb.append("&szlig;");
            } else if (c == 'Ç') {
                sb.append("&Ccedil;");
            } else if (c == 'È') {
                sb.append("&Egrave;");
            } else if (c == 'É') {
                sb.append("&Eacute;");
            } else if (c == 'Ê') {
                sb.append("&Ecirc;");
            } else if (c == 'Ë') {
                sb.append("&Euml;");
            } else if (c == 'Î') {
                sb.append("&Icirc;");
            } else if (c == 'Ï') {
                sb.append("&Iuml;");
            } else if (c == 'Ó') {
                sb.append("&Oacute;");
            } else if (c == 'Ô') {
                sb.append("&Ocirc;");
            } else if (c == 'Ö') {
                sb.append("&Ouml;");
            } else if (c == 'Š') {
                sb.append("&#352;");
            } else if (c == 'Û') {
                sb.append("&Ucirc;");
            } else if (c == 'Ü') {
                sb.append("&Uuml;");
            } else if (c == 'Ž') {
                sb.append("&#381;");
            } else if (c == '.') {
                sb.append("&#46;");
            } else if (c == '…') {
                sb.append("&#46;&#46;&#46;");
            } else if (c == ',') {
                sb.append("&#44;");
            } else if (c == '|') {
                sb.append("&#124;");
            } else if (c == '%') {
                sb.append("&#37;");
            } else if (c == '½') {
                sb.append(" 1&#47;2");
            } else if (c == '°' || c == '˚') {
                sb.append("&deg;");
            } else if (c == '@') {
                sb.append("&#64;");
            } else if (c == '©') {
                sb.append("&#copy;");
            } else if (c == '®') {
                sb.append("&#reg;");
            } else if (c == '=') {
                sb.append("&#61;");
            } else if (c == '≠') {
                sb.append("&ne;");
            } else if (c == '$') {
                sb.append("&#36;");
            } else if (c == '€' ||
                    new Integer(c).intValue() == 128) {
                sb.append("&euro;");
            } else if (c == '£') {
                sb.append("&pound;");
            } else if (c == '²') {
                sb.append("&sup2;");
            } else if (c == '~') {
                sb.append("&#126;");
            } else if (c == '×') {
                sb.append("&times;");
            } else if (c == 'Đ') {
                sb.append("&#272;");
            } else if (c == '³') {
                sb.append("&#179;");
            } else if (c == '\r' ||
                    new Integer(c).intValue() == 65533 ||
                    new Integer(c).intValue() == 945 ||
                    new Integer(c).intValue() == 1103 ||
                    new Integer(c).intValue() == 151 ||
                    new Integer(c).intValue() == 8202 ||
                    new Integer(c).intValue() == 167 ||
                    new Integer(c).intValue() == 1042 ||
                    new Integer(c).intValue() == 1086 ||
                    new Integer(c).intValue() == 1087 ||
                    new Integer(c).intValue() == 1083 ||
                    new Integer(c).intValue() == 1110 ||
                    new Integer(c).intValue() == 1042 ||
                    new Integer(c).intValue() == 1076 ||
                    new Integer(c).intValue() == 1089 ||
                    new Integer(c).intValue() == 1074 ||
                    new Integer(c).intValue() == 1072 ||
                    new Integer(c).intValue() == 9829 || // '♥'
                    new Integer(c).intValue() == 28 || // 
                    new Integer(c).intValue() == 8206) {
                sb.append(""); // empty or non-latin (?) characters
            } else if (c == '^' ||
                    new Integer(c).intValue() == 770 ||
                    new Integer(c).intValue() == 776) {
                sb.append(""); // accents
            } else if (c == '\n') {
                 // Handle Newline
                sb.append("&lt;br/&gt;");
            } else {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    /*public static String escapeHTML(String s) {
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        for (int i = 0; i < n; i++) {
            char c = s.charAt(i);
            switch (c) {
                case '<':
                    sb.append("&lt;");
                    break;
                case '>':
                    sb.append("&gt;");
                    break;
                case '\'':
                    sb.append("&#39;");
                    break;
                case '"':
                    sb.append("&quot;");
                    break;
                case ',':
                    sb.append("&#44;");
                    break;

                default:
                    sb.append(c);
                    break;
            }
        }
        return sb.toString();
    }*/

    public static String preLemmatise(String s){
        s = desencode(s);

        StringBuffer sb = new StringBuffer(s.length());
        int len = s.length();
        char c;
        for (int i = 0; i < len; i++) {
            c = s.charAt(i);

            if (c == '"' || c == '«' || c == '»' ||
                    new Integer(c).intValue() == 8220 ||
                    new Integer(c).intValue() == 8221) { // double quotes : "
                sb.append("");
            } else if (new Integer(c).intValue() == 160 || // non-br space
                       new Integer(c).intValue() == 8200 ||
                       new Integer(c).intValue() == 8201 ||
                       new Integer(c).intValue() == 8197 ||
                       new Integer(c).intValue() == 8239) {
                sb.append(" ");
            } else if (c == '-' ||
                    new Integer(c).intValue() == 173 ||
                    new Integer(c).intValue() == 8212 ||
                    new Integer(c).intValue() == 8211 ||
                    new Integer(c).intValue() == 8209) { // -
                sb.append("-");
            } else if (c == '*' ||
                    new Integer(c).intValue() == 8226 ||
                    new Integer(c).intValue() == 183) { // bullets : *
                sb.append("");
            } else if (c == '\'' || c == '’' || c == '`' || c == '´' ||
                    new Integer(c).intValue() == 8216 ||
                    new Integer(c).intValue() == 146 ||
                    new Integer(c).intValue() == 145) { // simple quotes
                sb.append("'");
            } else if (new Integer(c).intValue() == 8218) {
                sb.append(",");
            } else if (c == '\t') {
                sb.append(" ");
            } else if (c == '&') {
                sb.append(" ");
            } else if (c == '<') {
                sb.append(" ");
            } else if (c == '>') {
                sb.append(" ");
            } else if (c == '#') {
                sb.append(" ");
            } else if (c == '+') {
                sb.append(" ");
            } else if (c == '_') {
                sb.append("_");
            } else if (c == '(') {
                sb.append(" ");
            } else if (c == ')') {
                sb.append(" ");
            } else if (c == '[') {
                sb.append(" ");
            } else if (c == ']') {
                sb.append(" ");
            } else if (c == '{') {
                sb.append(" ");
            } else if (c == '}') {
                sb.append(" ");
            } else if (c == '¡') {
                sb.append(" ");
            } else if (c == '¿') {
                sb.append(" ");
            } else if (c == 'œ') {
                // diphtongues cassées
                sb.append("oe");
            } else if (c == 'Œ') {
                sb.append("Oe");
            } else if (c == 'æ') {
                sb.append("ae");
            } else if (c == 'Æ') {
                sb.append("Ae");
            } else if (c == '|') {
                sb.append(" ");
            } else if (c == '½') {
                sb.append(" 1/2");
            } else if (c == '©') {
                sb.append(" ");
            } else if (c == '®') {
                sb.append(" ");
            } else if (c == '=') {
                sb.append(" ");
            } else if (c == '≠') {
                sb.append(" ");
            } else if (c == '$') {
                sb.append(" dollar ");
            } else if (c == '¢') {
                sb.append(" cent ");
            } else if (c == '€' ||
                    new Integer(c).intValue() == 128) {
                sb.append(" euro ");
            } else if (c == '£') {
                sb.append(" livre sterling ");
            } else if (c == '²') {
                sb.append(" ");
            } else if (c == '³') {
                sb.append(" ");
            } else if (c == '\r' ||
                    new Integer(c).intValue() == 65533 ||
                    new Integer(c).intValue() == 945 ||
                    new Integer(c).intValue() == 1103 ||
                    new Integer(c).intValue() == 151 ||
                    new Integer(c).intValue() == 8202 ||
                    new Integer(c).intValue() == 167 ||
                    new Integer(c).intValue() == 1042 ||
                    new Integer(c).intValue() == 1086 ||
                    new Integer(c).intValue() == 1087 ||
                    new Integer(c).intValue() == 1083 ||
                    new Integer(c).intValue() == 1110 ||
                    new Integer(c).intValue() == 1042 ||
                    new Integer(c).intValue() == 1076 ||
                    new Integer(c).intValue() == 1089 ||
                    new Integer(c).intValue() == 1074 ||
                    new Integer(c).intValue() == 9829 || // '♥'
                    new Integer(c).intValue() == 28 || // 
                    new Integer(c).intValue() == 1072 ||
                    new Integer(c).intValue() == 8206) {
                sb.append(""); // empty or non-latin (?) characters
            } else if (c == '^' ||
                    new Integer(c).intValue() == 770) {
                sb.append(""); // accents
            } else if (c == '\n') // Handle Newline
            {
                sb.append(" ");
            } else {
            }
        }
        return sb.toString();
    }

    public static String desEscapeHTML(String s){
        String s2 = s;
        s2 = StringUtils.replace(s2,"&amp;", "&");
        s2 = StringUtils.replace(s2,"&lt;br/&gt;", "\n");
        s2 = StringUtils.replace(s2,"&sup2;", "²");
        s2 = StringUtils.replace(s2,"&pound;", "£");
        s2 = StringUtils.replace(s2,"&euro;", "€");
        s2 = StringUtils.replace(s2,"&cent;", "¢");
        s2 = StringUtils.replace(s2,"&#36;", "\\$");
        s2 = StringUtils.replace(s2,"&#61;", "=");
        s2 = StringUtils.replace(s2,"&#reg;", "®");
        s2 = StringUtils.replace(s2,"&#copy;", "©");
        s2 = StringUtils.replace(s2,"&#64;", "@");
        s2 = StringUtils.replace(s2,"&deg;", "°");
        s2 = StringUtils.replace(s2,"&#37;", "%");
        s2 = StringUtils.replace(s2,"&#124;", "|");
        s2 = StringUtils.replace(s2,"&#44;", ",");
        s2 = StringUtils.replace(s2,"&#46;", ".");
        s2 = StringUtils.replace(s2,"&Ucirc;", "Û");
        s2 = StringUtils.replace(s2,"&Ouml;", "Ö");
        s2 = StringUtils.replace(s2,"&Ocirc;", "Ô");
        s2 = StringUtils.replace(s2,"&Iuml;", "Ï");
        s2 = StringUtils.replace(s2,"&Icirc;", "Î");
        s2 = StringUtils.replace(s2,"&Euml;", "Ë");
        s2 = StringUtils.replace(s2,"&Ecirc;", "Ê");
        s2 = StringUtils.replace(s2,"&Eacute;", "É");
        s2 = StringUtils.replace(s2,"&Egrave;", "È");
        s2 = StringUtils.replace(s2,"&Ccedil;", "Ç");
        s2 = StringUtils.replace(s2,"&szlig;", "ß");
        s2 = StringUtils.replace(s2,"&Acirc;", "Â");
        s2 = StringUtils.replace(s2,"&Agrave;", "À");
        s2 = StringUtils.replace(s2,"&Aacute;", "Á");
        s2 = StringUtils.replace(s2,"&#382;", "ž");
        s2 = StringUtils.replace(s2,"&uuml;", "ü");
        s2 = StringUtils.replace(s2,"&ucirc;", "û");
        s2 = StringUtils.replace(s2,"&ugrave;", "ù");
        s2 = StringUtils.replace(s2,"&uacute;", "ú");
        s2 = StringUtils.replace(s2,"&ouml;", "ö");
        s2 = StringUtils.replace(s2,"&ocirc;", "ô");
        s2 = StringUtils.replace(s2,"&oacute;", "ó");
        s2 = StringUtils.replace(s2,"&ntilde;", "ñ");
        s2 = StringUtils.replace(s2,"&iuml;", "ï");
        s2 = StringUtils.replace(s2,"&icirc;", "î");
        s2 = StringUtils.replace(s2,"&iacute;", "í");
        s2 = StringUtils.replace(s2,"&euml;", "ë");
        s2 = StringUtils.replace(s2,"&ecirc;", "ê");
        s2 = StringUtils.replace(s2,"&egrave;", "è");
        s2 = StringUtils.replace(s2,"&eacute;", "é");
        s2 = StringUtils.replace(s2,"&ccedil;", "ç");
        s2 = StringUtils.replace(s2,"&atilde;", "ã");
        s2 = StringUtils.replace(s2,"&auml;", "ä");
        s2 = StringUtils.replace(s2,"&acirc;", "â");
        s2 = StringUtils.replace(s2,"&agrave;", "à");
        s2 = StringUtils.replace(s2,"&aacute;", "á");
        s2 = StringUtils.replace(s2,"&#261;", "ą");
        s2 = StringUtils.replace(s2,"&#263;", "ć");
        s2 = StringUtils.replace(s2,"&#352;", "Š");
        s2 = StringUtils.replace(s2,"&iquest;", "¿");
        s2 = StringUtils.replace(s2,"&#63;", "?");
        s2 = StringUtils.replace(s2,"&iexcl;", "¡");
        s2 = StringUtils.replace(s2,"&#33;", "!");
        s2 = StringUtils.replace(s2,"&#58;", ":");
        s2 = StringUtils.replace(s2,"&#125;", "}");
        s2 = StringUtils.replace(s2,"&#126;", "~");
        s2 = StringUtils.replace(s2,"&#123;", "{");
        s2 = StringUtils.replace(s2,"&#93;", "]");
        s2 = StringUtils.replace(s2,"&#91;", "[");
        s2 = StringUtils.replace(s2,"&#41;", ")");
        s2 = StringUtils.replace(s2,"&#40;", "(");
        s2 = StringUtils.replace(s2,"&#95;", "_");
        s2 = StringUtils.replace(s2,"&#44;", "+");
        s2 = StringUtils.replace(s2,"&#59;", ";");
        s2 = StringUtils.replace(s2,"&#35;", "#");
        s2 = StringUtils.replace(s2,"&#47;", "/");
        s2 = StringUtils.replace(s2,"&gt;", ">");
        s2 = StringUtils.replace(s2,"&lt;", "<");
        s2 = StringUtils.replace(s2,"&#39;", "'");
        s2 = StringUtils.replace(s2,"&#42;", "*");
        s2 = StringUtils.replace(s2,"&#45;", "-");
        s2 = StringUtils.replace(s2,"&#272;", "Đ");
        s2 = StringUtils.replace(s2,"&nbsp;", " ");
        s2 = StringUtils.replace(s2,"&ne;", "≠");
        s2 = StringUtils.replace(s2,"&quot;", "\"");
        Pattern p = Pattern.compile("&.{1,10};");
        Matcher m = p.matcher(s2);
        while(m.find()){
            Out.printErreur("Caractère HTML échappé inconnu en provenance de la base : "+m.group());
        }
        return s2;
    }

    public static String desEscapeHTMLText(String s) {
        Pattern p0 = Pattern.compile("&[A-Za-z0-9]{1,10};");
        Matcher m0 = p0.matcher(s);
        if(!(m0.find())){
            return s;
        }
        String s2 = s;
        s2 = StringUtils.replace(s2,"&amp;", "&");
        s2 = StringUtils.replace(s2,"&#38;", "&");

        s2 = StringUtils.replace(s2,"&#8194;", " ");
        s2 = StringUtils.replace(s2,"&#8200;", " ");
        s2 = StringUtils.replace(s2,"&#8201;", " ");
        s2 = StringUtils.replace(s2,"&#8239;", " ");
        s2 = StringUtils.replace(s2,"&thinsp;", " ");
        s2 = StringUtils.replace(s2,"&apos;", "'");
        s2 = StringUtils.replace(s2,"&#8216;", "'");
        s2 = StringUtils.replace(s2,"&#8217;", "'");
        s2 = StringUtils.replace(s2,"&#8242;", "'");
        s2 = StringUtils.replace(s2,"&#146;", "'");
        s2 = StringUtils.replace(s2,"&#147;", "\"");
        s2 = StringUtils.replace(s2,"&#8220;", "\"");
        s2 = StringUtils.replace(s2,"&ldquo;", "\"");
        s2 = StringUtils.replace(s2,"&lsquo;", "\"");
        s2 = StringUtils.replace(s2,"&rdquo;", "\"");
        s2 = StringUtils.replace(s2,"&#8221;", "\"");
        s2 = StringUtils.replace(s2,"&#8230;", "…");
        s2 = StringUtils.replace(s2,"&#x2026;", "…");
        s2 = StringUtils.replace(s2,"&#8364;", "€");
        s2 = StringUtils.replace(s2,"&#x20ac;", "€");
        s2 = StringUtils.replace(s2,"&#8206;", "");
        s2 = StringUtils.replace(s2,"&#13;", ""); // carriage return
        s2 = StringUtils.replace(s2,"&#xD;", ""); // carriage return
        s2 = StringUtils.replace(s2,"&#8232;", ""); // line separator
        s2 = StringUtils.replace(s2,"&rlm;", ""); // right to left mark
        s2 = StringUtils.replace(s2,"&#8207;", ""); // right to left mark
        s2 = StringUtils.replace(s2,"&bull;", ""); // bullets
        s2 = StringUtils.replace(s2,"&trade;", "™");
        s2 = StringUtils.replace(s2,"&#8482;", "™");
        s2 = StringUtils.replace(s2,"&#776;", "¨");
        s2 = StringUtils.replace(s2,"&#8208;", "‐");
        s2 = StringUtils.replace(s2,"&#8209;", "‑");
        s2 = StringUtils.replace(s2,"&#150;", "–");
        s2 = StringUtils.replace(s2,"&ndash;", "–");
        s2 = StringUtils.replace(s2,"&#8211;", "–");
        s2 = StringUtils.replace(s2,"&ndash;", "–");
        s2 = StringUtils.replace(s2,"&#8212;", "—");
        s2 = StringUtils.replace(s2,"&#x2014;", "—");
        s2 = StringUtils.replace(s2,"&mdash;", "—");
        s2 = StringUtils.replace(s2,"&#140;", "œ");
        s2 = StringUtils.replace(s2,"&#156;", "Œ");
        s2 = StringUtils.replace(s2,"&#x153;", "œ");
        s2 = StringUtils.replace(s2,"&#x152;", "Œ");
        s2 = StringUtils.replace(s2,"&OElig;", "Œ");
        s2 = StringUtils.replace(s2,"&ne;", "≠");


        s2 = StringUtils.replace(s2,"&#32;", " ");
        s2 = StringUtils.replace(s2,"&#33;", "!");
        s2 = StringUtils.replace(s2,"&#34;", "\"");
        s2 = StringUtils.replace(s2,"&#35;", "#");
        s2 = StringUtils.replace(s2,"&#36;", "$");
        s2 = StringUtils.replace(s2,"&#37;", "%");
        s2 = StringUtils.replace(s2,"&#38;", "&");
        s2 = StringUtils.replace(s2,"&#39;", "'");
        s2 = StringUtils.replace(s2,"&#40;", "(");
        s2 = StringUtils.replace(s2,"&#41;", ")");
        s2 = StringUtils.replace(s2,"&#42;", "*");
        s2 = StringUtils.replace(s2,"&#43;", "+");
        s2 = StringUtils.replace(s2,"&#44;", ",");
        s2 = StringUtils.replace(s2,"&#45;", "-");
        s2 = StringUtils.replace(s2,"&#46;", ".");
        s2 = StringUtils.replace(s2,"&#47;", "/");
        s2 = StringUtils.replace(s2,"&#48;", "0");
        s2 = StringUtils.replace(s2,"&#49;", "1");
        s2 = StringUtils.replace(s2,"&#50;", "2");
        s2 = StringUtils.replace(s2,"&#51;", "3");
        s2 = StringUtils.replace(s2,"&#52;", "4");
        s2 = StringUtils.replace(s2,"&#53;", "5");
        s2 = StringUtils.replace(s2,"&#54;", "6");
        s2 = StringUtils.replace(s2,"&#55;", "7");
        s2 = StringUtils.replace(s2,"&#56;", "8");
        s2 = StringUtils.replace(s2,"&#57;", "9");
        s2 = StringUtils.replace(s2,"&#58;", ":");
        s2 = StringUtils.replace(s2,"&#59;", ";");
        s2 = StringUtils.replace(s2,"&#60;", "<");
        s2 = StringUtils.replace(s2,"&#61;", "=");
        s2 = StringUtils.replace(s2,"&#62;", ">");
        s2 = StringUtils.replace(s2,"&#63;", "?");
        s2 = StringUtils.replace(s2,"&#64;", "@");
        s2 = StringUtils.replace(s2,"&#65;", "A");
        s2 = StringUtils.replace(s2,"&#66;", "B");
        s2 = StringUtils.replace(s2,"&#67;", "C");
        s2 = StringUtils.replace(s2,"&#68;", "D");
        s2 = StringUtils.replace(s2,"&#69;", "E");
        s2 = StringUtils.replace(s2,"&#70;", "F");
        s2 = StringUtils.replace(s2,"&#71;", "G");
        s2 = StringUtils.replace(s2,"&#72;", "H");
        s2 = StringUtils.replace(s2,"&#73;", "I");
        s2 = StringUtils.replace(s2,"&#74;", "J");
        s2 = StringUtils.replace(s2,"&#75;", "K");
        s2 = StringUtils.replace(s2,"&#76;", "L");
        s2 = StringUtils.replace(s2,"&#77;", "M");
        s2 = StringUtils.replace(s2,"&#78;", "N");
        s2 = StringUtils.replace(s2,"&#79;", "O");
        s2 = StringUtils.replace(s2,"&#80;", "P");
        s2 = StringUtils.replace(s2,"&#81;", "Q");
        s2 = StringUtils.replace(s2,"&#82;", "R");
        s2 = StringUtils.replace(s2,"&#83;", "S");
        s2 = StringUtils.replace(s2,"&#84;", "T");
        s2 = StringUtils.replace(s2,"&#85;", "U");
        s2 = StringUtils.replace(s2,"&#86;", "V");
        s2 = StringUtils.replace(s2,"&#87;", "W");
        s2 = StringUtils.replace(s2,"&#88;", "X");
        s2 = StringUtils.replace(s2,"&#89;", "Y");
        s2 = StringUtils.replace(s2,"&#90;", "Z");
        s2 = StringUtils.replace(s2,"&#91;", "[");
        s2 = StringUtils.replace(s2,"&#92;", "\\");
        s2 = StringUtils.replace(s2,"&#93;", "]");
        s2 = StringUtils.replace(s2,"&#94;", "^");
        s2 = StringUtils.replace(s2,"&#95;", "_");
        s2 = StringUtils.replace(s2,"&#96;", "`");
        s2 = StringUtils.replace(s2,"&#97;", "a");
        s2 = StringUtils.replace(s2,"&#98;", "b");
        s2 = StringUtils.replace(s2,"&#99;", "c");
        s2 = StringUtils.replace(s2,"&#032;", " ");
        s2 = StringUtils.replace(s2,"&#033;", "!");
        s2 = StringUtils.replace(s2,"&#034;", "\"");
        s2 = StringUtils.replace(s2,"&#035;", "#");
        s2 = StringUtils.replace(s2,"&#036;", "$");
        s2 = StringUtils.replace(s2,"&#037;", "%");
        s2 = StringUtils.replace(s2,"&#038;", "&");
        s2 = StringUtils.replace(s2,"&#039;", "'");
        s2 = StringUtils.replace(s2,"&#040;", "(");
        s2 = StringUtils.replace(s2,"&#041;", ")");
        s2 = StringUtils.replace(s2,"&#042;", "*");
        s2 = StringUtils.replace(s2,"&#043;", "+");
        s2 = StringUtils.replace(s2,"&#044;", ",");
        s2 = StringUtils.replace(s2,"&#045;", "-");
        s2 = StringUtils.replace(s2,"&#046;", ".");
        s2 = StringUtils.replace(s2,"&#047;", "/");
        s2 = StringUtils.replace(s2,"&#048;", "0");
        s2 = StringUtils.replace(s2,"&#049;", "1");
        s2 = StringUtils.replace(s2,"&#050;", "2");
        s2 = StringUtils.replace(s2,"&#051;", "3");
        s2 = StringUtils.replace(s2,"&#052;", "4");
        s2 = StringUtils.replace(s2,"&#053;", "5");
        s2 = StringUtils.replace(s2,"&#054;", "6");
        s2 = StringUtils.replace(s2,"&#055;", "7");
        s2 = StringUtils.replace(s2,"&#056;", "8");
        s2 = StringUtils.replace(s2,"&#057;", "9");
        s2 = StringUtils.replace(s2,"&#058;", ":");
        s2 = StringUtils.replace(s2,"&#059;", ";");
        s2 = StringUtils.replace(s2,"&#060;", "<");
        s2 = StringUtils.replace(s2,"&#061;", "=");
        s2 = StringUtils.replace(s2,"&#062;", ">");
        s2 = StringUtils.replace(s2,"&#063;", "?");
        s2 = StringUtils.replace(s2,"&#064;", "@");
        s2 = StringUtils.replace(s2,"&#065;", "A");
        s2 = StringUtils.replace(s2,"&#066;", "B");
        s2 = StringUtils.replace(s2,"&#067;", "C");
        s2 = StringUtils.replace(s2,"&#068;", "D");
        s2 = StringUtils.replace(s2,"&#069;", "E");
        s2 = StringUtils.replace(s2,"&#070;", "F");
        s2 = StringUtils.replace(s2,"&#071;", "G");
        s2 = StringUtils.replace(s2,"&#072;", "H");
        s2 = StringUtils.replace(s2,"&#073;", "I");
        s2 = StringUtils.replace(s2,"&#074;", "J");
        s2 = StringUtils.replace(s2,"&#075;", "K");
        s2 = StringUtils.replace(s2,"&#076;", "L");
        s2 = StringUtils.replace(s2,"&#077;", "M");
        s2 = StringUtils.replace(s2,"&#078;", "N");
        s2 = StringUtils.replace(s2,"&#079;", "O");
        s2 = StringUtils.replace(s2,"&#080;", "P");
        s2 = StringUtils.replace(s2,"&#081;", "Q");
        s2 = StringUtils.replace(s2,"&#082;", "R");
        s2 = StringUtils.replace(s2,"&#083;", "S");
        s2 = StringUtils.replace(s2,"&#084;", "T");
        s2 = StringUtils.replace(s2,"&#085;", "U");
        s2 = StringUtils.replace(s2,"&#086;", "V");
        s2 = StringUtils.replace(s2,"&#087;", "W");
        s2 = StringUtils.replace(s2,"&#088;", "X");
        s2 = StringUtils.replace(s2,"&#089;", "Y");
        s2 = StringUtils.replace(s2,"&#090;", "Z");
        s2 = StringUtils.replace(s2,"&#091;", "[");
        s2 = StringUtils.replace(s2,"&#092;", "\\");
        s2 = StringUtils.replace(s2,"&#093;", "]");
        s2 = StringUtils.replace(s2,"&#094;", "^");
        s2 = StringUtils.replace(s2,"&#095;", "_");
        s2 = StringUtils.replace(s2,"&#096;", "`");
        s2 = StringUtils.replace(s2,"&#097;", "a");
        s2 = StringUtils.replace(s2,"&#098;", "b");
        s2 = StringUtils.replace(s2,"&#099;", "c");
        s2 = StringUtils.replace(s2,"&#100;", "d");
        s2 = StringUtils.replace(s2,"&#101;", "e");
        s2 = StringUtils.replace(s2,"&#102;", "f");
        s2 = StringUtils.replace(s2,"&#103;", "g");
        s2 = StringUtils.replace(s2,"&#104;", "h");
        s2 = StringUtils.replace(s2,"&#105;", "i");
        s2 = StringUtils.replace(s2,"&#106;", "j");
        s2 = StringUtils.replace(s2,"&#107;", "k");
        s2 = StringUtils.replace(s2,"&#108;", "l");
        s2 = StringUtils.replace(s2,"&#109;", "m");
        s2 = StringUtils.replace(s2,"&#110;", "n");
        s2 = StringUtils.replace(s2,"&#111;", "o");
        s2 = StringUtils.replace(s2,"&#112;", "p");
        s2 = StringUtils.replace(s2,"&#113;", "q");
        s2 = StringUtils.replace(s2,"&#114;", "r");
        s2 = StringUtils.replace(s2,"&#115;", "s");
        s2 = StringUtils.replace(s2,"&#116;", "t");
        s2 = StringUtils.replace(s2,"&#117;", "u");
        s2 = StringUtils.replace(s2,"&#118;", "v");
        s2 = StringUtils.replace(s2,"&#119;", "w");
        s2 = StringUtils.replace(s2,"&#120;", "x");
        s2 = StringUtils.replace(s2,"&#121;", "y");
        s2 = StringUtils.replace(s2,"&#122;", "z");
        s2 = StringUtils.replace(s2,"&#123;", "{");
        s2 = StringUtils.replace(s2,"&#124;", "|");
        s2 = StringUtils.replace(s2,"&#125;", "}");
        s2 = StringUtils.replace(s2,"&#126;", "~");
        s2 = StringUtils.replace(s2,"&#160;", " ");
        s2 = StringUtils.replace(s2,"&#161;", "¡");
        s2 = StringUtils.replace(s2,"&#162;", "¢");
        s2 = StringUtils.replace(s2,"&#163;", "£");
        s2 = StringUtils.replace(s2,"&#164;", "¤");
        s2 = StringUtils.replace(s2,"&#165;", "¥");
        s2 = StringUtils.replace(s2,"&#166;", "¦");
        s2 = StringUtils.replace(s2,"&#167;", "§");
        s2 = StringUtils.replace(s2,"&#168;", "¨");
        s2 = StringUtils.replace(s2,"&#169;", "©");
        s2 = StringUtils.replace(s2,"&#170;", "ª");
        s2 = StringUtils.replace(s2,"&#171;", "«");
        s2 = StringUtils.replace(s2,"&#172;", "¬");
        s2 = StringUtils.replace(s2,"&#173;", "­");
        s2 = StringUtils.replace(s2,"&#174;", "®");
        s2 = StringUtils.replace(s2,"&#175;", "¯");
        s2 = StringUtils.replace(s2,"&#176;", "°");
        s2 = StringUtils.replace(s2,"&#177;", "±");
        s2 = StringUtils.replace(s2,"&#178;", "²");
        s2 = StringUtils.replace(s2,"&#179;", "³");
        s2 = StringUtils.replace(s2,"&#180;", "´");
        s2 = StringUtils.replace(s2,"&#181;", "µ");
        s2 = StringUtils.replace(s2,"&#182;", "¶");
        s2 = StringUtils.replace(s2,"&#183;", "·");
        s2 = StringUtils.replace(s2,"&#184;", "¸");
        s2 = StringUtils.replace(s2,"&#185;", "¹");
        s2 = StringUtils.replace(s2,"&#186;", "º");
        s2 = StringUtils.replace(s2,"&#187;", "»");
        s2 = StringUtils.replace(s2,"&#188;", "¼");
        s2 = StringUtils.replace(s2,"&#189;", "½");
        s2 = StringUtils.replace(s2,"&#190;", "¾");
        s2 = StringUtils.replace(s2,"&#191;", "¿");
        s2 = StringUtils.replace(s2,"&#192;", "À");
        s2 = StringUtils.replace(s2,"&#193;", "Á");
        s2 = StringUtils.replace(s2,"&#194;", "Â");
        s2 = StringUtils.replace(s2,"&#195;", "Ã");
        s2 = StringUtils.replace(s2,"&#196;", "Ä");
        s2 = StringUtils.replace(s2,"&#197;", "Å");
        s2 = StringUtils.replace(s2,"&#198;", "Æ");
        s2 = StringUtils.replace(s2,"&#199;", "Ç");
        s2 = StringUtils.replace(s2,"&#200;", "È");
        s2 = StringUtils.replace(s2,"&#201;", "É");
        s2 = StringUtils.replace(s2,"&#202;", "Ê");
        s2 = StringUtils.replace(s2,"&#203;", "Ë");
        s2 = StringUtils.replace(s2,"&#204;", "Ì");
        s2 = StringUtils.replace(s2,"&#205;", "Í");
        s2 = StringUtils.replace(s2,"&#206;", "Î");
        s2 = StringUtils.replace(s2,"&#207;", "Ï");
        s2 = StringUtils.replace(s2,"&#208;", "Ð");
        s2 = StringUtils.replace(s2,"&#209;", "Ñ");
        s2 = StringUtils.replace(s2,"&#210;", "Ò");
        s2 = StringUtils.replace(s2,"&#211;", "Ó");
        s2 = StringUtils.replace(s2,"&#212;", "Ô");
        s2 = StringUtils.replace(s2,"&#213;", "Õ");
        s2 = StringUtils.replace(s2,"&#214;", "Ö");
        s2 = StringUtils.replace(s2,"&#215;", "×");
        s2 = StringUtils.replace(s2,"&#216;", "Ø");
        s2 = StringUtils.replace(s2,"&#217;", "Ù");
        s2 = StringUtils.replace(s2,"&#218;", "Ú");
        s2 = StringUtils.replace(s2,"&#219;", "Û");
        s2 = StringUtils.replace(s2,"&#220;", "Ü");
        s2 = StringUtils.replace(s2,"&#221;", "Ý");
        s2 = StringUtils.replace(s2,"&#222;", "Þ");
        s2 = StringUtils.replace(s2,"&#223;", "ß");
        s2 = StringUtils.replace(s2,"&#224;", "à");
        s2 = StringUtils.replace(s2,"&#225;", "á");
        s2 = StringUtils.replace(s2,"&#226;", "â");
        s2 = StringUtils.replace(s2,"&#227;", "ã");
        s2 = StringUtils.replace(s2,"&#228;", "ä");
        s2 = StringUtils.replace(s2,"&#229;", "å");
        s2 = StringUtils.replace(s2,"&#230;", "æ");
        s2 = StringUtils.replace(s2,"&#231;", "ç");
        s2 = StringUtils.replace(s2,"&#232;", "è");
        s2 = StringUtils.replace(s2,"&#233;", "é");
        s2 = StringUtils.replace(s2,"&#234;", "ê");
        s2 = StringUtils.replace(s2,"&#235;", "ë");
        s2 = StringUtils.replace(s2,"&#236;", "ì");
        s2 = StringUtils.replace(s2,"&#237;", "í");
        s2 = StringUtils.replace(s2,"&#238;", "î");
        s2 = StringUtils.replace(s2,"&#239;", "ï");
        s2 = StringUtils.replace(s2,"&#240;", "ð");
        s2 = StringUtils.replace(s2,"&#241;", "ñ");
        s2 = StringUtils.replace(s2,"&#242;", "ò");
        s2 = StringUtils.replace(s2,"&#243;", "ó");
        s2 = StringUtils.replace(s2,"&#244;", "ô");
        s2 = StringUtils.replace(s2,"&#245;", "õ");
        s2 = StringUtils.replace(s2,"&#246;", "ö");
        s2 = StringUtils.replace(s2,"&#247;", "÷");
        s2 = StringUtils.replace(s2,"&#248;", "ø");
        s2 = StringUtils.replace(s2,"&#249;", "ù");
        s2 = StringUtils.replace(s2,"&#250;", "ú");
        s2 = StringUtils.replace(s2,"&#251;", "û");
        s2 = StringUtils.replace(s2,"&#252;", "ü");
        s2 = StringUtils.replace(s2,"&#253;", "ý");
        s2 = StringUtils.replace(s2,"&#254;", "þ");
        s2 = StringUtils.replace(s2,"&#255;", "ÿ");
        s2 = StringUtils.replace(s2,"&#256;", "Ā");
        s2 = StringUtils.replace(s2,"&#257;", "ā");
        s2 = StringUtils.replace(s2,"&#258;", "Ă");
        s2 = StringUtils.replace(s2,"&#259;", "ă");
        s2 = StringUtils.replace(s2,"&#260;", "Ą");
        s2 = StringUtils.replace(s2,"&#261;", "ą");
        s2 = StringUtils.replace(s2,"&#262;", "Ć");
        s2 = StringUtils.replace(s2,"&#263;", "ć");
        s2 = StringUtils.replace(s2,"&#264;", "Ĉ");
        s2 = StringUtils.replace(s2,"&#265;", "ĉ");
        s2 = StringUtils.replace(s2,"&#266;", "Ċ");
        s2 = StringUtils.replace(s2,"&#267;", "ċ");
        s2 = StringUtils.replace(s2,"&#268;", "Č");
        s2 = StringUtils.replace(s2,"&#269;", "č");
        s2 = StringUtils.replace(s2,"&#270;", "Ď");
        s2 = StringUtils.replace(s2,"&#271;", "ď");
        s2 = StringUtils.replace(s2,"&#272;", "Đ");
        s2 = StringUtils.replace(s2,"&#273;", "đ");
        s2 = StringUtils.replace(s2,"&#274;", "Ē");
        s2 = StringUtils.replace(s2,"&#275;", "ē");
        s2 = StringUtils.replace(s2,"&#276;", "Ĕ");
        s2 = StringUtils.replace(s2,"&#277;", "ĕ");
        s2 = StringUtils.replace(s2,"&#278;", "Ė");
        s2 = StringUtils.replace(s2,"&#279;", "ė");
        s2 = StringUtils.replace(s2,"&#280;", "Ę");
        s2 = StringUtils.replace(s2,"&#281;", "ę");
        s2 = StringUtils.replace(s2,"&#282;", "Ě");
        s2 = StringUtils.replace(s2,"&#283;", "ě");
        s2 = StringUtils.replace(s2,"&#284;", "Ĝ");
        s2 = StringUtils.replace(s2,"&#285;", "ĝ");
        s2 = StringUtils.replace(s2,"&#286;", "Ğ");
        s2 = StringUtils.replace(s2,"&#287;", "ğ");
        s2 = StringUtils.replace(s2,"&#288;", "Ġ");
        s2 = StringUtils.replace(s2,"&#289;", "ġ");
        s2 = StringUtils.replace(s2,"&#290;", "Ģ");
        s2 = StringUtils.replace(s2,"&#291;", "ģ");
        s2 = StringUtils.replace(s2,"&#292;", "Ĥ");
        s2 = StringUtils.replace(s2,"&#293;", "ĥ");
        s2 = StringUtils.replace(s2,"&#294;", "Ħ");
        s2 = StringUtils.replace(s2,"&#295;", "ħ");
        s2 = StringUtils.replace(s2,"&#296;", "Ĩ");
        s2 = StringUtils.replace(s2,"&#297;", "ĩ");
        s2 = StringUtils.replace(s2,"&#298;", "Ī");
        s2 = StringUtils.replace(s2,"&#299;", "ī");
        s2 = StringUtils.replace(s2,"&#300;", "Ĭ");
        s2 = StringUtils.replace(s2,"&#301;", "ĭ");
        s2 = StringUtils.replace(s2,"&#302;", "Į");
        s2 = StringUtils.replace(s2,"&#303;", "į");
        s2 = StringUtils.replace(s2,"&#304;", "İ");
        s2 = StringUtils.replace(s2,"&#305;", "ı");
        s2 = StringUtils.replace(s2,"&#306;", "Ĳ");
        s2 = StringUtils.replace(s2,"&#307;", "ĳ");
        s2 = StringUtils.replace(s2,"&#308;", "Ĵ");
        s2 = StringUtils.replace(s2,"&#309;", "ĵ");
        s2 = StringUtils.replace(s2,"&#310;", "Ķ");
        s2 = StringUtils.replace(s2,"&#311;", "ķ");
        s2 = StringUtils.replace(s2,"&#312;", "ĸ");
        s2 = StringUtils.replace(s2,"&#313;", "Ĺ");
        s2 = StringUtils.replace(s2,"&#314;", "ĺ");
        s2 = StringUtils.replace(s2,"&#315;", "Ļ");
        s2 = StringUtils.replace(s2,"&#316;", "ļ");
        s2 = StringUtils.replace(s2,"&#317;", "Ľ");
        s2 = StringUtils.replace(s2,"&#318;", "ľ");
        s2 = StringUtils.replace(s2,"&#319;", "Ŀ");
        s2 = StringUtils.replace(s2,"&#320;", "ŀ");
        s2 = StringUtils.replace(s2,"&#321;", "Ł");
        s2 = StringUtils.replace(s2,"&#322;", "ł");
        s2 = StringUtils.replace(s2,"&#323;", "Ń");
        s2 = StringUtils.replace(s2,"&#324;", "ń");
        s2 = StringUtils.replace(s2,"&#325;", "Ņ");
        s2 = StringUtils.replace(s2,"&#326;", "ņ");
        s2 = StringUtils.replace(s2,"&#327;", "Ň");
        s2 = StringUtils.replace(s2,"&#328;", "ň");
        s2 = StringUtils.replace(s2,"&#329;", "ŉ");
        s2 = StringUtils.replace(s2,"&#330;", "Ŋ");
        s2 = StringUtils.replace(s2,"&#331;", "ŋ");
        s2 = StringUtils.replace(s2,"&#332;", "Ō");
        s2 = StringUtils.replace(s2,"&#333;", "ō");
        s2 = StringUtils.replace(s2,"&#334;", "Ŏ");
        s2 = StringUtils.replace(s2,"&#335;", "ŏ");
        s2 = StringUtils.replace(s2,"&#336;", "Ő");
        s2 = StringUtils.replace(s2,"&#337;", "ő");
        s2 = StringUtils.replace(s2,"&#338;", "Œ");
        s2 = StringUtils.replace(s2,"&#339;", "œ");
        s2 = StringUtils.replace(s2,"&#340;", "Ŕ");
        s2 = StringUtils.replace(s2,"&#341;", "ŕ");
        s2 = StringUtils.replace(s2,"&#342;", "Ŗ");
        s2 = StringUtils.replace(s2,"&#343;", "ŗ");
        s2 = StringUtils.replace(s2,"&#344;", "Ř");
        s2 = StringUtils.replace(s2,"&#345;", "ř");
        s2 = StringUtils.replace(s2,"&#346;", "Ś");
        s2 = StringUtils.replace(s2,"&#347;", "ś");
        s2 = StringUtils.replace(s2,"&#348;", "Ŝ");
        s2 = StringUtils.replace(s2,"&#349;", "ŝ");
        s2 = StringUtils.replace(s2,"&#350;", "Ş");
        s2 = StringUtils.replace(s2,"&#351;", "ş");
        s2 = StringUtils.replace(s2,"&#352;", "Š");
        s2 = StringUtils.replace(s2,"&#353;", "š");
        s2 = StringUtils.replace(s2,"&#354;", "Ţ");
        s2 = StringUtils.replace(s2,"&#355;", "ţ");
        s2 = StringUtils.replace(s2,"&#356;", "Ť");
        s2 = StringUtils.replace(s2,"&#357;", "ť");
        s2 = StringUtils.replace(s2,"&#358;", "Ŧ");
        s2 = StringUtils.replace(s2,"&#359;", "ŧ");
        s2 = StringUtils.replace(s2,"&#360;", "Ũ");
        s2 = StringUtils.replace(s2,"&#361;", "ũ");
        s2 = StringUtils.replace(s2,"&#362;", "Ū");
        s2 = StringUtils.replace(s2,"&#363;", "ū");
        s2 = StringUtils.replace(s2,"&#364;", "Ŭ");
        s2 = StringUtils.replace(s2,"&#365;", "ŭ");
        s2 = StringUtils.replace(s2,"&#366;", "Ů");
        s2 = StringUtils.replace(s2,"&#367;", "ů");
        s2 = StringUtils.replace(s2,"&#368;", "Ű");
        s2 = StringUtils.replace(s2,"&#369;", "ű");
        s2 = StringUtils.replace(s2,"&#370;", "Ų");
        s2 = StringUtils.replace(s2,"&#371;", "ų");
        s2 = StringUtils.replace(s2,"&#372;", "Ŵ");
        s2 = StringUtils.replace(s2,"&#373;", "ŵ");
        s2 = StringUtils.replace(s2,"&#374;", "Ŷ");
        s2 = StringUtils.replace(s2,"&#375;", "ŷ");
        s2 = StringUtils.replace(s2,"&#376;", "Ÿ");
        s2 = StringUtils.replace(s2,"&#377;", "Ź");
        s2 = StringUtils.replace(s2,"&#378;", "ź");
        s2 = StringUtils.replace(s2,"&#379;", "Ż");
        s2 = StringUtils.replace(s2,"&#380;", "ż");
        s2 = StringUtils.replace(s2,"&#381;", "Ž");
        s2 = StringUtils.replace(s2,"&#382;", "ž");
        s2 = StringUtils.replace(s2,"&#383;", "ſ");
        s2 = StringUtils.replace(s2,"&#340;", "Ŕ");
        s2 = StringUtils.replace(s2,"&#341;", "ŕ");
        s2 = StringUtils.replace(s2,"&#342;", "Ŗ");
        s2 = StringUtils.replace(s2,"&#343;", "ŗ");
        s2 = StringUtils.replace(s2,"&#344;", "Ř");
        s2 = StringUtils.replace(s2,"&#345;", "ř");
        s2 = StringUtils.replace(s2,"&#346;", "Ś");
        s2 = StringUtils.replace(s2,"&#347;", "ś");
        s2 = StringUtils.replace(s2,"&#348;", "Ŝ");
        s2 = StringUtils.replace(s2,"&#349;", "ŝ");
        s2 = StringUtils.replace(s2,"&#350;", "Ş");
        s2 = StringUtils.replace(s2,"&#351;", "ş");
        s2 = StringUtils.replace(s2,"&#352;", "Š");
        s2 = StringUtils.replace(s2,"&#353;", "š");
        s2 = StringUtils.replace(s2,"&#354;", "Ţ");
        s2 = StringUtils.replace(s2,"&#355;", "ţ");
        s2 = StringUtils.replace(s2,"&#356;", "Ť");
        s2 = StringUtils.replace(s2,"&#577;", "ť");
        s2 = StringUtils.replace(s2,"&#358;", "Ŧ");
        s2 = StringUtils.replace(s2,"&#359;", "ŧ");
        s2 = StringUtils.replace(s2,"&#360;", "Ũ");
        s2 = StringUtils.replace(s2,"&#361;", "ũ");
        s2 = StringUtils.replace(s2,"&#362;", "Ū");
        s2 = StringUtils.replace(s2,"&#363;", "ū");
        s2 = StringUtils.replace(s2,"&#364;", "Ŭ");
        s2 = StringUtils.replace(s2,"&#365;", "ŭ");
        s2 = StringUtils.replace(s2,"&#366;", "Ů");
        s2 = StringUtils.replace(s2,"&#367;", "ů");
        s2 = StringUtils.replace(s2,"&#368;", "Ű");
        s2 = StringUtils.replace(s2,"&#369;", "ű");
        s2 = StringUtils.replace(s2,"&#370;", "Ų");
        s2 = StringUtils.replace(s2,"&#371;", "ų");
        s2 = StringUtils.replace(s2,"&#372;", "Ŵ");
        s2 = StringUtils.replace(s2,"&#373;", "ŵ");
        s2 = StringUtils.replace(s2,"&#374;", "Ŷ");
        s2 = StringUtils.replace(s2,"&#375;", "ŷ");
        s2 = StringUtils.replace(s2,"&#376;", "Ÿ");
        s2 = StringUtils.replace(s2,"&#377;", "Ź");
        s2 = StringUtils.replace(s2,"&#378;", "ź");
        s2 = StringUtils.replace(s2,"&#379;", "Ż");
        s2 = StringUtils.replace(s2,"&#380;", "ż");
        s2 = StringUtils.replace(s2,"&#381;", "Ž");
        s2 = StringUtils.replace(s2,"&#382;", "ž");
        s2 = StringUtils.replace(s2,"&#383;", "ſ");
        s2 = StringUtils.replace(s2,"&euro;", "€");
        s2 = StringUtils.replace(s2,"&nbsp;", " ");
        s2 = StringUtils.replace(s2,"&quot;", "\"");
        s2 = StringUtils.replace(s2,"&amp;", "&");
        s2 = StringUtils.replace(s2,"&lt;", "<");
        s2 = StringUtils.replace(s2,"&gt;", ">");
        s2 = StringUtils.replace(s2,"&nbsp;", " ");
        s2 = StringUtils.replace(s2,"&iexcl;", "¡");
        s2 = StringUtils.replace(s2,"&cent;", "¢");
        s2 = StringUtils.replace(s2,"&pound;", "£");
        s2 = StringUtils.replace(s2,"&curren;", "¤");
        s2 = StringUtils.replace(s2,"&yen;", "¥");
        s2 = StringUtils.replace(s2,"&brvbar;", "¦");
        s2 = StringUtils.replace(s2,"&sect;", "§");
        s2 = StringUtils.replace(s2,"&uml;", "¨");
        s2 = StringUtils.replace(s2,"&copy;", "©");
        s2 = StringUtils.replace(s2,"&ordf;", "ª");
        s2 = StringUtils.replace(s2,"&not;", "¬");
        s2 = StringUtils.replace(s2,"&shy;", "­");
        s2 = StringUtils.replace(s2,"&reg;", "®");
        s2 = StringUtils.replace(s2,"&macr;", "¯");
        s2 = StringUtils.replace(s2,"&deg;", "°");
        s2 = StringUtils.replace(s2,"&plusmn;", "±");
        s2 = StringUtils.replace(s2,"&sup2;", "²");
        s2 = StringUtils.replace(s2,"&sup3;", "³");
        s2 = StringUtils.replace(s2,"&acute;", "´");
        s2 = StringUtils.replace(s2,"&micro;", "µ");
        s2 = StringUtils.replace(s2,"&para;", "¶");
        s2 = StringUtils.replace(s2,"&middot;", "·");
        s2 = StringUtils.replace(s2,"&cedil;", "¸");
        s2 = StringUtils.replace(s2,"&sup1;", "¹");
        s2 = StringUtils.replace(s2,"&ordm;", "º");
        s2 = StringUtils.replace(s2,"&raquo;", "»");
        s2 = StringUtils.replace(s2,"&frac14;", "¼");
        s2 = StringUtils.replace(s2,"&frac12;", "½");
        s2 = StringUtils.replace(s2,"&frac34;", "¾");
        s2 = StringUtils.replace(s2,"&iquest;", "¿");
        s2 = StringUtils.replace(s2,"&Agrave;", "À");
        s2 = StringUtils.replace(s2,"&Aacute;", "Á");
        s2 = StringUtils.replace(s2,"&Acirc;", "Â");
        s2 = StringUtils.replace(s2,"&Atilde;", "Ã");
        s2 = StringUtils.replace(s2,"&Auml;", "Ä");
        s2 = StringUtils.replace(s2,"&Aring;", "Å");
        s2 = StringUtils.replace(s2,"&AElig;", "Æ");
        s2 = StringUtils.replace(s2,"&Ccedil;", "Ç");
        s2 = StringUtils.replace(s2,"&Egrave;", "È");
        s2 = StringUtils.replace(s2,"&Eacute;", "É");
        s2 = StringUtils.replace(s2,"&Ecirc;", "Ê");
        s2 = StringUtils.replace(s2,"&Euml;", "Ë");
        s2 = StringUtils.replace(s2,"&Igrave;", "Ì");
        s2 = StringUtils.replace(s2,"&Iacute;", "Í");
        s2 = StringUtils.replace(s2,"&Icirc;", "Î");
        s2 = StringUtils.replace(s2,"&Iuml;", "Ï");
        s2 = StringUtils.replace(s2,"&ETH;", "Ð");
        s2 = StringUtils.replace(s2,"&Ntilde;", "Ñ");
        s2 = StringUtils.replace(s2,"&Ograve;", "Ò");
        s2 = StringUtils.replace(s2,"&Oacute;", "Ó");
        s2 = StringUtils.replace(s2,"&Ocirc;", "Ô");
        s2 = StringUtils.replace(s2,"&Otilde;", "Õ");
        s2 = StringUtils.replace(s2,"&Ouml;", "Ö");
        s2 = StringUtils.replace(s2,"&times;", "×");
        s2 = StringUtils.replace(s2,"&Oslash;", "Ø");
        s2 = StringUtils.replace(s2,"&Ugrave;", "Ù");
        s2 = StringUtils.replace(s2,"&Uacute;", "Ú");
        s2 = StringUtils.replace(s2,"&Ucirc;", "Û");
        s2 = StringUtils.replace(s2,"&Uuml;", "Ü");
        s2 = StringUtils.replace(s2,"&Yacute;", "Ý");
        s2 = StringUtils.replace(s2,"&THORN;", "Þ");
        s2 = StringUtils.replace(s2,"&szlig;", "ß");
        s2 = StringUtils.replace(s2,"&agrave;", "à");
        s2 = StringUtils.replace(s2,"&aacute;", "á");
        s2 = StringUtils.replace(s2,"&acirc;", "â");
        s2 = StringUtils.replace(s2,"&atilde;", "ã");
        s2 = StringUtils.replace(s2,"&auml;", "ä");
        s2 = StringUtils.replace(s2,"&aring;", "å");
        s2 = StringUtils.replace(s2,"&aelig;", "æ");
        s2 = StringUtils.replace(s2,"&ccedil;", "ç");
        s2 = StringUtils.replace(s2,"&egrave;", "è");
        s2 = StringUtils.replace(s2,"&eacute;", "é");
        s2 = StringUtils.replace(s2,"&ecirc;", "ê");
        s2 = StringUtils.replace(s2,"&euml;", "ë");
        s2 = StringUtils.replace(s2,"&igrave;", "ì");
        s2 = StringUtils.replace(s2,"&iacute;", "í");
        s2 = StringUtils.replace(s2,"&icirc;", "î");
        s2 = StringUtils.replace(s2,"&iuml;", "ï");
        s2 = StringUtils.replace(s2,"&eth;", "ð");
        s2 = StringUtils.replace(s2,"&ntilde;", "ñ");
        s2 = StringUtils.replace(s2,"&ograve;", "ò");
        s2 = StringUtils.replace(s2,"&oacute;", "ó");
        s2 = StringUtils.replace(s2,"&ocirc;", "ô");
        s2 = StringUtils.replace(s2,"&otilde;", "õ");
        s2 = StringUtils.replace(s2,"&ouml;", "ö");
        s2 = StringUtils.replace(s2,"&divide;", "÷");
        s2 = StringUtils.replace(s2,"&oslash;", "ø");
        s2 = StringUtils.replace(s2,"&ugrave;", "ù");
        s2 = StringUtils.replace(s2,"&uacute;", "ú");
        s2 = StringUtils.replace(s2,"&ucirc;", "û");
        s2 = StringUtils.replace(s2,"&uuml;", "ü");
        s2 = StringUtils.replace(s2,"&yacute;", "ý");
        s2 = StringUtils.replace(s2,"&thorn;", "þ");

        s2 = StringUtils.replace(s2,"&oelig;", "œ");
        s2 = StringUtils.replace(s2,"&laquo;", "\"");
        s2 = StringUtils.replace(s2,"&rsquo;", "\"");
        s2 = StringUtils.replace(s2,"&hellip;", "…");
        s2 = StringUtils.replace(s2,"&263;", "ć");
        s2 = StringUtils.replace(s2,"&quot;", "\"");
        s2 = StringUtils.replace(s2,"&amp;", "&");

        Pattern p = Pattern.compile("&[A-Za-z0-9]{1,10};");
        Matcher m = p.matcher(s2);
        while(m.find()){
            Out.printErreur("Echappement HTML non couvert par desEscapeHTMLText : "+m.group()+" dans : "+s2);
        }
        return s2;
    }

    public static String desEscapeUnicode(String s){
        String s2 = s;

        int i = s2.indexOf("\\u");
        while(i>=0){
            try{
                String s3 = s2.substring(i, i + 6);
                int s4 = Integer.parseInt(s3.substring(2, 6), 16);
                char s5 = (char) s4;
                s2 = StringUtils.replace(s2, s3, "" + s5);
                i = s2.indexOf("\\u");
            } catch(NumberFormatException nfe){
                System.out.println(s2);
                nfe.printStackTrace();
                break;
            } catch(StringIndexOutOfBoundsException sioobe){
                System.out.println(s2);
                sioobe.printStackTrace();
                break;
            }
        }
        return s2;
    }
    
    /**
     * Supprime les tags HTML d'un texte
     */
    public static String deHTMLize(String s) {
        s = desEscapeHTMLText(s.trim());
        String[] ss = s.trim().split("\\<(.+?)\\>");
        String sss = "";
        for(int i=0; i<ss.length; i++){
            if(!ss[i].startsWith("<")){
                sss += ss[i] + " ";
            } else if(!ss[i].endsWith(">")){
                sss += ss[i].substring(ss[i].lastIndexOf(">")+1, ss[i].length()) + " ";
            }
        }
        return sss;
    }

    /**
     * Déséchappe une URL (remplace les caractères en '%XX' par le caractère normal)
     */
    public static String desEscapeURL(String s){
        s = StringUtils.replace(s,"%", "\\u00");
        s = desEscapeUnicode(s);
        s = desencode(s);
        return s;
    }
}
